/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.network;

import java.util.Collection;
import java.util.Vector;
import java.util.regex.Pattern;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nodeapps.IPAddressException;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.network.InterfaceInfo;

public class NodeInfo {
    String m_name;
    Vector m_interfaceList;

    public NodeInfo(String nodeName) {
        this.m_name = nodeName;
        this.m_interfaceList = new Vector();
    }

    public void addInterface(InterfaceInfo inf) {
        this.m_interfaceList.add(inf);
    }

    public String getName() {
        return this.m_name;
    }

    public Vector getInterfaceList() {
        return this.m_interfaceList;
    }

    public Collection<InterfaceInfo> getInterfacesByName(String name) {
        Vector<InterfaceInfo> matchingIfs = new Vector<InterfaceInfo>();
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        String regexp = null;
        regexp = nativeSystem.isUnixSystem() ? name.replaceAll("\\*", ".*") : name.toLowerCase().replaceAll("\\*", ".*");
        Pattern p = Pattern.compile(regexp);
        for (InterfaceInfo ifInfo : this.m_interfaceList) {
            String ifName = null;
            ifName = nativeSystem.isUnixSystem() ? ifInfo.getName() : ifInfo.getName().toLowerCase();
            if (!p.matcher(ifName).matches()) continue;
            matchingIfs.add(ifInfo);
        }
        return matchingIfs;
    }

    public Collection<InterfaceInfo> getInterfacesBySubnetId(String subnetId) {
        Vector<InterfaceInfo> matchingIfs = new Vector<InterfaceInfo>();
        for (InterfaceInfo ifInfo : this.m_interfaceList) {
            if (!this.sameIPAddresses(subnetId, ifInfo.getSubnet())) continue;
            matchingIfs.add(ifInfo);
        }
        return matchingIfs;
    }

    public Collection<InterfaceInfo> getInterfacesBySubnetAndName(String subnetId, String name) {
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        Vector<InterfaceInfo> matchingIfs = new Vector<InterfaceInfo>();
        String regexp = null;
        regexp = nativeSystem.isUnixSystem() ? name.replaceAll("\\*", ".*") : name.toLowerCase().replaceAll("\\*", ".*");
        Pattern p = Pattern.compile(regexp);
        for (InterfaceInfo ifInfo : this.m_interfaceList) {
            String ifName = null;
            ifName = nativeSystem.isUnixSystem() ? ifInfo.getName() : ifInfo.getName().toLowerCase();
            if (!this.sameIPAddresses(subnetId, ifInfo.getSubnet()) || !p.matcher(ifName).matches()) continue;
            matchingIfs.add(ifInfo);
        }
        return matchingIfs;
    }

    private boolean sameIPAddresses(String ip1, String ip2) {
        boolean same = false;
        try {
            same = IPAddressUtil.sameIPAddresses((String)ip1, (String)ip2);
        }
        catch (IPAddressException ipEx) {
            Trace.out((String)("IPAddressException occured. mesg: " + ipEx.getMessage()));
        }
        return same;
    }
}

